

<?php $__env->startSection('content'); ?>
    <style>
        body {
            background-color: #99ff99 !important;
            font-family: Arial, sans-serif;
        }

        .report-card {
            background-color: #004d00;
            color: #ffffff;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        }

        .report-title-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        .company-name {
            margin: 0;
            font-size: 28px;
        }

        .print-btn {
            background-color: #28a745;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            color: #fff;
            cursor: pointer;
        }

        .print-btn:hover {
            background-color: #218838;
        }

        .right-info {
            font-size: 14px;
            color: #ffffff;
        }

        table {
            background-color: #004d00;
            color: #ffffff;
        }

        thead th {
            background-color: #003300;
        }

        tfoot tr.table-warning td {
            background-color: #006600;
            font-weight: bold;
        }

        .alert-info {
            background-color: #006600;
            color: #ffffff;
            border: none;
            font-weight: bold;
        }

        /* 🖨️ Hide sidebar and buttons when printing */
        @media print {

            .sidebar,
            .navbar,
            .print-btn,
            .alert-info,
            a.print-btn {
                display: none !important;
            }

            body {
                background: white !important;
                color: black !important;
            }

            .report-card {
                box-shadow: none;
                color: black !important;
                background-color: white !important;
            }

            table {
                color: black !important;
                background-color: white !important;
            }

            thead th {
                background-color: #ddd !important;
                color: black !important;
            }

            tfoot tr.table-warning td {
                background-color: #f0f0f0 !important;
                color: black !important;
            }
        }
    </style>

    <div class="container mt-4 report-card">
        <div class="report-title-bar">
            <div>
                <?php
                    $companyName = \App\Models\Setting::value('CompanyName');
                ?>
                <h2 class="company-name"><?php echo e($companyName ?? 'Default Company'); ?></h2>
                <h4 class="fw-bold">📄 විකුණුම් වාර්තාව</h4>
            </div>
            <div>
                <?php
                    $settingDate = \App\Models\Setting::value('value');
                ?>

                <span class="right-info">
                    <?php echo e(\Carbon\Carbon::parse($settingDate)->format('Y-m-d H:i')); ?>

                </span>
                <button class="print-btn" onclick="window.print()">🖨️ මුද්‍රණය</button>
            </div>
        </div>

        
        <div class="alert alert-info fw-bold">
            Sales Total: <?php echo e(number_format($salesTotal, 2)); ?>

        </div>

        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>විස්තරය</th>
                    <th>ලැබීම්</th>
                    <th>ගෙවීම</th>
                </tr>
            </thead>
            <tbody>
                
                <?php $__currentLoopData = $reportData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($row['description']); ?></td>
                        <td><?php echo e($row['dr'] ? number_format(abs($row['dr']), 2) : ''); ?></td>
                        <td><?php echo e($row['cr'] ? number_format(abs($row['cr']), 2) : ''); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>

            <tfoot>
                <tr class="fw-bold">
                    <td>Total</td>
                    <td><?php echo e(number_format(abs($totalDr), 2)); ?></td>
                    <td><?php echo e(number_format(abs($totalCr), 2)); ?></td>
                </tr>
                <tr class="fw-bold table-warning">
                    <td>ඇතැති මුදල්</td>
                    <td colspan="2">
                        <?php
                            $diff = $totalDr + $totalCr;
                        ?>
                        <?php if($diff < 0): ?>
                            <span class="text-danger"><?php echo e(number_format($diff, 2)); ?></span>
                        <?php else: ?>
                            <span class="text-success"><?php echo e(number_format($diff, 2)); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr class="fw-bold table-warning" id="profit-row">
                    <td>💰 Profit</td>
                    <td colspan="2" class="text-success">
                        <span id="profit-value" style="display: none;">
                            <?php echo e(number_format($totalProfit, 2)); ?>

                            <br>
                           
                        </span>
                        <input type="password" id="profit-password" placeholder="Enter password" style="padding:2px 5px;" />
                    </td>
                </tr>
                <tr class="fw-bold table-warning">
                    <td>Total Damages</td>
                    <td colspan="2" class="text-danger">
                        <?php echo e(number_format($totalDamages, 2)); ?>

                    </td>
                </tr>
                <tr class="fw-bold table-warning">
                    <td colspan="3">
                        <div style="display: flex; justify-content: space-between; gap: 10px; flex-wrap: wrap;">
                            <div
                                style="flex:1; background-color:#004d00; padding:10px; border-radius:5px; text-align:center; color:white;">
                                අද දින පරණ නය <br>
                                <strong><?php echo e($totalOldLoans); ?></strong>
                            </div>
                            <div
                                style="flex:1; background-color:#006600; padding:10px; border-radius:5px; text-align:center; color:white;">
                               අද දින නය ගැනීම<br>
                               <strong><?php echo e(abs($totaltodayLoans)); ?></strong>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr class="fw-bold table-warning">
                    <td colspan="3">
                        <div style="display: flex; justify-content: space-between; gap: 10px; flex-wrap: wrap;">
                            <div
                                style="flex:1; background-color:#004d00; padding:10px; border-radius:5px; text-align:center; color:white;">
                                Total Qty Sold<br>
                                <strong><?php echo e(number_format($totalQtySold, 2)); ?></strong>
                            </div>
                            <div
                                style="flex:1; background-color:#006600; padding:10px; border-radius:5px; text-align:center; color:white;">
                                Total Bills Printed<br>
                                <strong><?php echo e($totalBillsPrinted); ?></strong>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr class="fw-bold table-warning">
                    <td colspan="3">
                        <div style="display: flex; justify-content: space-between; gap: 10px; flex-wrap: wrap;">
                            <div
                                style="flex:1; background-color:#003300; padding:10px; border-radius:5px; text-align:center; color:white;">
                                First Bill Printed Time<br>
                                <strong><?php echo e($firstBillTime); ?></strong><br>
                                <small>(Bill No: <?php echo e($firstBillNo); ?>)</small>
                            </div>
                            <div
                                style="flex:1; background-color:#005500; padding:10px; border-radius:5px; text-align:center; color:white;">
                                Last Bill Printed Time<br>
                                <strong><?php echo e($lastBillTime); ?></strong><br>
                                <small>(Bill No: <?php echo e($lastBillNo); ?>)</small>
                            </div>
                        </div>
                    </td>
                </tr>
            </tfoot>
        </table>

        <a href="<?php echo e(route('send.financial.report')); ?>" class="print-btn" style="text-decoration: none;">
            📧 Send Email
        </a>
    </div>

    <script>
        const profitInput = document.getElementById("profit-password");
        const profitValue = document.getElementById("profit-value");

        profitInput.addEventListener("input", function () {
            if (this.value === "nethma123") {
                profitValue.style.display = "";
                this.style.display = "none"; // hide input after correct password
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/wdaylk/public_html/sms/application/resources/views/dashboard/reports/financial.blade.php ENDPATH**/ ?>